@section('title', 'Promo Aktif')

<x-admin>
<div class="container">
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h3 class="font-weight-bold">Promo Aktif</h3>
                <a href="{{ route('admin.gambarpromo.create') }}" class="btn btn-outline-secondary">Tambah Promo</a>
            </div>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Jenis Promo</th>
                        <th>Tampilan</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($promos as $promo)
                    <tr>
                        <td><b>{{ $promo->nama }}</b></td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div>
                                    <div class="mb-2">{!! $promo->caption !!}</div>
                                    @if($promo->jenis_promo)
                                        <ul>
                                            @foreach(json_decode($promo->jenis_promo, true) as $jenis)
                                                <li>{{ $jenis }}</li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                                @if($promo->gambar)
                                    <img src="{{ asset('storage/' . $promo->gambar) }}" alt="Promo" style="max-width:120px;max-height:120px;margin-left:16px;border-radius:8px;">
                                @endif
                            </div>
                        </td>
                        <td><a href="{{ route('admin.gambarpromo.edit', $promo->id) }}" class="btn btn-primary btn-sm">Lihat/edit</a></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="3" class="text-center text-muted">Belum ada promo yang terdaftar.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
</x-admin> 