<form method="POST" action="{{ $action }}">
    @csrf
    @if($isEdit)
        @method('PUT')
    @endif
    <div class="mb-3">
        <label class="font-weight-bold">Jenis Bank</label>
        <input type="text" name="bank" class="form-control" placeholder="Misalkan, bank man...." value="{{ old('bank', $simulasi->bank ?? '') }}">
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Jenis Program</label>
        <div id="jenis-program-list">
            @php
                $jenisList = old('jenis_program', $simulasi->jenis_program ?? []);
                if (is_string($jenisList)) $jenisList = json_decode($jenisList, true) ?? [];
                if (empty($jenisList)) $jenisList = [''];
            @endphp
            @foreach($jenisList as $i => $jenis)
            <div class="input-group mb-2 jenis-program-item">
                <select name="jenis_program[]" class="form-control">
                    <option value="">Pilih Jenis Program</option>
                    <option value="Fix 1 Tahun" {{ $jenis == 'Fix 1 Tahun' ? 'selected' : '' }}>Fix 1 Tahun</option>
                    <option value="Fix 2 Tahun" {{ $jenis == 'Fix 2 Tahun' ? 'selected' : '' }}>Fix 2 Tahun</option>
                    <option value="Fix 3 Tahun" {{ $jenis == 'Fix 3 Tahun' ? 'selected' : '' }}>Fix 3 Tahun</option>
                    <option value="Floating" {{ $jenis == 'Floating' ? 'selected' : '' }}>Floating</option>
                </select>
                <button type="button" class="btn btn-danger btn-remove-jenis" onclick="removeJenisProgram(this)">-</button>
            </div>
            @endforeach
        </div>
        <div class="input-group mb-2">
            <input type="text" id="jenis-program-custom" class="form-control" placeholder="Tambahkan Program Lainnya">
            <button type="button" class="btn btn-secondary" onclick="addJenisProgram()">+</button>
        </div>
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Suku Bunga</label>
        <input type="text" name="suku_bunga" class="form-control" placeholder="Misalkan, 2.89%" value="{{ old('suku_bunga', $simulasi->suku_bunga ?? '') }}">
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Tempo Angsuran</label>
        <div id="tempo-angsuran-list">
            @php
                $tempoList = old('tempo_angsuran', $simulasi->tempo_angsuran ?? []);
                if (is_string($tempoList)) $tempoList = json_decode($tempoList, true) ?? [];
                if (empty($tempoList)) $tempoList = [''];
            @endphp
            @foreach($tempoList as $i => $tempo)
            <div class="input-group mb-2 tempo-angsuran-item">
                <select name="tempo_angsuran[]" class="form-control">
                    <option value="">Pilih Tempo Angsuran</option>
                    <option value="5 Tahun" {{ $tempo == '5 Tahun' ? 'selected' : '' }}>5 Tahun</option>
                    <option value="10 Tahun" {{ $tempo == '10 Tahun' ? 'selected' : '' }}>10 Tahun</option>
                    <option value="15 Tahun" {{ $tempo == '15 Tahun' ? 'selected' : '' }}>15 Tahun</option>
                    <option value="20 Tahun" {{ $tempo == '20 Tahun' ? 'selected' : '' }}>20 Tahun</option>
                </select>
                <button type="button" class="btn btn-danger btn-remove-tempo" onclick="removeTempoAngsuran(this)">-</button>
            </div>
            @endforeach
        </div>
        <div class="input-group mb-2">
            <input type="text" id="tempo-angsuran-custom" class="form-control" placeholder="Tambahkan Tempo Angsuran Lainnya">
            <button type="button" class="btn btn-secondary" onclick="addTempoAngsuran()">+</button>
        </div>
    </div>
    <div class="text-right">
        <button type="submit" class="btn btn-warning">SIMPAN</button>
    </div>
</form>
<script>
function addJenisProgram() {
    var val = document.getElementById('jenis-program-custom').value;
    var div = document.createElement('div');
    div.className = 'input-group mb-2 jenis-program-item';
    if (val) {
        div.innerHTML = `<input type=\"text\" name=\"jenis_program[]\" class=\"form-control\" value="${val}">
            <button type=\"button\" class=\"btn btn-danger btn-remove-jenis\" onclick=\"removeJenisProgram(this)\">-</button>`;
    } else {
        div.innerHTML = `<select name=\"jenis_program[]\" class=\"form-control\">
            <option value=\"\">Pilih Jenis Program</option>
            <option value=\"Fix 1 Tahun\">Fix 1 Tahun</option>
            <option value=\"Fix 2 Tahun\">Fix 2 Tahun</option>
            <option value=\"Fix 3 Tahun\">Fix 3 Tahun</option>
            <option value=\"Floating\">Floating</option>
        </select>
        <button type=\"button\" class=\"btn btn-danger btn-remove-jenis\" onclick=\"removeJenisProgram(this)\">-</button>`;
    }
    document.getElementById('jenis-program-list').appendChild(div);
    document.getElementById('jenis-program-custom').value = '';
}
function removeJenisProgram(btn) {
    var list = document.getElementById('jenis-program-list');
    if (list.children.length > 1) {
        btn.parentElement.remove();
    }
}
function addTempoAngsuran() {
    var val = document.getElementById('tempo-angsuran-custom').value;
    var div = document.createElement('div');
    div.className = 'input-group mb-2 tempo-angsuran-item';
    if (val) {
        div.innerHTML = `<input type=\"text\" name=\"tempo_angsuran[]\" class=\"form-control\" value="${val}">
            <button type=\"button\" class=\"btn btn-danger btn-remove-tempo\" onclick=\"removeTempoAngsuran(this)\">-</button>`;
    } else {
        div.innerHTML = `<select name=\"tempo_angsuran[]\" class=\"form-control\">
            <option value=\"\">Pilih Tempo Angsuran</option>
            <option value=\"5 Tahun\">5 Tahun</option>
            <option value=\"10 Tahun\">10 Tahun</option>
            <option value=\"15 Tahun\">15 Tahun</option>
            <option value=\"20 Tahun\">20 Tahun</option>
        </select>
        <button type=\"button\" class=\"btn btn-danger btn-remove-tempo\" onclick=\"removeTempoAngsuran(this)\">-</button>`;
    }
    document.getElementById('tempo-angsuran-list').appendChild(div);
    document.getElementById('tempo-angsuran-custom').value = '';
}
function removeTempoAngsuran(btn) {
    var list = document.getElementById('tempo-angsuran-list');
    if (list.children.length > 1) {
        btn.parentElement.remove();
    }
}
</script> 